varying vec2 texture_coordinate;
varying vec2 image_coordinate;
uniform sampler2D source;
uniform sampler2D image;
uniform float brighten;

void main() {
	vec3 color = texture2D(source, texture_coordinate).rgb;
	vec3 overlay = texture2D(image, image_coordinate).rgb;
	float r = color.r;
	float g = color.g;
	float b = color.b;
	
	float r1 = overlay.r;
	float g1 = overlay.g;
	float b1 = overlay.b;

	if(r < 0.5) {
		r = r * r1 / 0.5;
	} else {
		r = 1.0 - ((1.0 - r) * (1.0 - r1) / 0.5);
	}
	
	if(g < 0.5) {
		g = g * g1 / 0.5;
	} else {
		g = 1.0 - ((1.0 - g) * (1.0 - g1) / 0.5);
	}

	if(b < 0.5) {
		b = b * b1 / 0.5;
	} else {
		b = 1.0 - ((1.0 - b) * (1.0 - b1) / 0.5);
	}

	gl_FragColor = vec4(vec3(r,g,b)*brighten,1);
}
